# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 5
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR5_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate
    if current_round == 1:
        return "C"
    
    # Check for always cooperate or always defect in opponent's code
    always_cooperate = "return 'C'" in opponent_program_code or "always cooperate" in opponent_program_code.lower()
    always_defect = "return 'D'" in opponent_program_code or "always defect" in opponent_program_code.lower()
    
    # Exploit always cooperate
    if always_cooperate:
        return "D"
    
    # If opponent always defects, defect to minimize losses
    if always_defect:
        return "D"
    
    # Rounds 9-10: Defect
    if current_round >= 9:
        return "D"
    
    # Tit-for-Tat for Rounds 2-8
    if opp_history:
        return opp_history[-1]
    
    # Default to cooperate if no history (shouldn't happen after Round 1)
    return "C"